# Version 2.3 - 2.4

This update will fixes an issue where promotions (and discounts) will check if the current basket is
a qualifying basket on a basket that already has discounts applied to it.  For example, if there is
a promotion where the grandtotal will have a 50% discount on baskets over £100, when `rebuildDiscount`
event is called a basket over £100 will quality for this promotion.  And if the basket does not
change at all but `rebuildDiscount` is called again (maybe by just pressing enter in the quantity
field without changing it) the promotion will see that the basket is worth £50 and no longer
qualifies for the promotion.  This update removes all discounts from the basket and reapplies them
on `rebuildDiscount`.  This can break sites which attempt to fix this in-project with a workaround.

## The `rebuildDiscount()` method in `Lib/Event/EvBasketCheckForDiscountListener.php`

### What breaks

* Nothing should be broken, but behavior is different.  Added `$this->_unapplyDiscounts($Event);`

### How to fix

* If `rebuildDiscount` was overridden in project to workout the described issue, then make sure `$this->_unapplyDiscounts($Event)` is called as early as convenient
